<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\CommandBus\SynchronizeMutation;

use IssetBV\PaymentBundle\CommandBus\SynchronizeMutation\SynchronizeMutationCommand;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use IssetBV\TalosBundle\Gateway\Request\Request;
use IssetBV\TalosBundle\Gateway\Request\Service;
use IssetBV\TalosBundle\Gateway\Shared\SingleField;
use IssetBV\TalosBundle\ResponseHandler\MutationResponseHandler;

/**
 * Class TalosSynchronizeMutationHandler.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizeMutationHandler
{
    /**
     * @var ApiGateway
     */
    private $apiGateway;

    /**
     * @var MutationResponseHandler
     */
    private $mutationResponseHandler;

    /**
     * TalosSynchronizeMutationsHandler constructor.
     *
     * @param ApiGateway $apiGateway
     * @param MutationResponseHandler $mutationResponseHandler
     */
    public function __construct(ApiGateway $apiGateway, MutationResponseHandler $mutationResponseHandler)
    {
        $this->apiGateway = $apiGateway;
        $this->mutationResponseHandler = $mutationResponseHandler;
    }

    /**
     * @param SynchronizeMutationCommand $command
     */
    public function handle(SynchronizeMutationCommand $command)
    {
        $mutationRequest = new Request(ClientData::empty(), [
            new Service('General', 'Status', [
                new SingleField('ObjectType', 'WalletMutation'),
                new SingleField('ObjectIdentifier', $command->getMutationIdentifier()),
            ]),
        ]);

        $mutationRequest->addResponseHandler($this->mutationResponseHandler);

        $this->apiGateway->send([$mutationRequest]);
    }
}
