<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\CancelPayment\CancelPaymentCommand as CancelPaymentCommandBusCommand;
use IssetBV\PaymentBundle\Domain\Identifier\UuidPaymentIdentifier;
use League\Tactician\CommandBus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CancelPaymentCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    public function __construct(CommandBus $commandBus)
    {
        parent::__construct('talos:payment:cancel');
        $this->commandBus = $commandBus;
    }

    protected function configure()
    {
        $this->addArgument('payment', InputArgument::REQUIRED);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->commandBus->handle(new CancelPaymentCommandBusCommand(UuidPaymentIdentifier::fromString($input->getArgument('payment'))));
    }
}
