<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Payment;

use Assert\Assertion;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class PaymentType
{
    const FIRST = 'First';
    const ONE_OFF = 'OneOff';
    const RECURRING = 'Recurring';

    private static $allowedValues = [
        self::FIRST,
        self::ONE_OFF,
        self::RECURRING,
    ];

    private $value;

    private function __construct(string $value)
    {
        Assertion::inArray($value, self::$allowedValues);
        $this->value = $value;
    }

    public function __toString()
    {
        return $this->value;
    }

    public function isFirst(): bool
    {
        return $this->value === self::FIRST;
    }

    public function isOneOff(): bool
    {
        return $this->value === self::ONE_OFF;
    }

    public function isRecurring(): bool
    {
        return $this->value === self::RECURRING;
    }

    public static function createFirst()
    {
        return new self(self::FIRST);
    }

    public static function createOneOff()
    {
        return new self(self::ONE_OFF);
    }

    public static function createRecurring()
    {
        return new self(self::RECURRING);
    }
}
