<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CancelPayment;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CannotCancelPaymentException extends \Exception
{
    public static function becauseThePaymentDoesNotExist(LocalPaymentIdentifier $paymentId): CannotCancelPaymentException
    {
        return new self('Cannot cancel the payment because no payment with id ' . $paymentId->asString() . ' exists');
    }

    public static function becauseThePaymentDoesNotHaveARemoteIdentifier(LocalPaymentIdentifier $paymentId): CannotCancelPaymentException
    {
        return new self('Cannot cancel the payment because the payment with id ' . $paymentId->asString() . ' has no remote identifier');
    }
}
