<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\CancelPayment;

use IssetBV\PaymentBundle\Domain\Identifier\LocalPaymentIdentifier;
use IssetBV\TalosBundle\Gateway\Request\ClientData;
use PhpOption\Option;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class CancelPaymentCommand
{
    /**
     * @var ClientData|null
     */
    private $clientData;

    /**
     * @var LocalPaymentIdentifier
     */
    private $paymentIdentifier;

    /**
     * CancelPaymentCommand constructor.
     *
     * @param LocalPaymentIdentifier $paymentIdentifier
     * @param ClientData|null $clientData
     */
    public function __construct(LocalPaymentIdentifier $paymentIdentifier, ClientData $clientData = null)
    {
        $this->paymentIdentifier = $paymentIdentifier;
        $this->clientData = $clientData;
    }

    public function getClientData(): Option
    {
        return Option::fromValue($this->clientData);
    }

    /**
     * @return LocalPaymentIdentifier
     */
    public function getPaymentIdentifier(): LocalPaymentIdentifier
    {
        return $this->paymentIdentifier;
    }
}
