<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Storage;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class CreatedUpdated.
 *
 * Note: Don't forget to add the HasLifecycleCallbacks annotation to your class otherwise dateUpdated will never be changed
 */
trait CreatedUpdatedFields
{
    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var DateTime
     * @ORM\Column(name="date_updated", type="datetime")
     */
    private $dateUpdated;

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }

    /**
     * @return DateTime
     */
    public function getDateUpdated(): DateTime
    {
        return $this->dateUpdated;
    }

    /**
     * @internal
     * @ORM\PreUpdate()
     */
    public function updateCrudFields()
    {
        $this->dateUpdated = new DateTime();
    }

    protected function initCrudFields()
    {
        $this->dateCreated = new DateTime();
        $this->dateUpdated = new DateTime();
    }
}
