<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PaymentBundle\Domain\Repository\PaymentRepository;
use PhpOption\Option;

/**
 * Class DoctrinePaymentRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DoctrinePaymentRepository extends EntityRepository implements PaymentRepository
{
    /**
     * @param string $paymentReference
     *
     * @return Option
     */
    public function findOneByReference(string $paymentReference): Option
    {
        return Option::ensure($this->findOneBy(['reference' => $paymentReference]));
    }

    /**
     * @param string $remoteIdentifier
     *
     * @return Option
     */
    public function findOneByRemoteIdentifier(string $remoteIdentifier): Option
    {
        return Option::ensure($this->findOneBy(['remoteIdentifier' => $remoteIdentifier]));
    }
}
