<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Request;

use JsonSerializable;

/**
 * Class Batch.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class Batch implements JsonSerializable
{
    /**
     * @var string
     */
    private $channel;

    /**
     * @var Request[]
     */
    private $requests;

    /**
     * Batch constructor.
     *
     * @param Request[] $requests
     * @param string $channel
     */
    public function __construct(array $requests, string $channel)
    {
        $this->requests = $requests;
        $this->channel = $channel;
    }

    /**
     * @deprecated
     *
     * @return array
     */
    public function toSerializable()
    {
        return $this->jsonSerialize();
    }

    /**
     * @return array
     */
    public function jsonSerialize()
    {
        return [
            'SenderCode' => 'Friday',
            'Channel' => $this->channel,
            'Requests' => $this->requests,
        ];
    }
}
