<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\TalosBundle\Exception\OpenSSLException;
use IssetBV\TalosBundle\Gateway\ApiGateway;
use IssetBV\TalosBundle\Gateway\Config\GatewayConfig;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Exception\InvalidArgumentException;
use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class TestTalosGatewayCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class TestCommand extends Command
{
    /**
     * @var ApiGateway
     */
    private $gateway;

    /**
     * @var GatewayConfig
     */
    private $gatewayConfig;

    /**
     * @var OutputInterface
     */
    private $output;

    /**
     * TestCommand constructor.
     *
     * @param ApiGateway $gateway
     * @param GatewayConfig $gatewayConfig
     */
    public function __construct(ApiGateway $gateway, GatewayConfig $gatewayConfig)
    {
        parent::__construct('talos:test');
        $this->gateway = $gateway;
        $this->gatewayConfig = $gatewayConfig;
        $this->output = new NullOutput();
    }

    /**
     * @throws InvalidArgumentException
     */
    protected function configure()
    {
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @throws OpenSSLException
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output = $output;
        $this->displayConfiguration();
    }

    private function displayConfiguration()
    {
        $table = new Table($this->output);
        $table->setHeaders(['Key' => 'Value']);
        $table->setRows([
            ['Api URL', $this->gatewayConfig->getApiUrl()],
            ['Public Key Fingerprint', $this->gatewayConfig->getPublicKey()->getFingerprint()],
            ['Request Engine Public Key Fingerprint', $this->gatewayConfig->getRequestEnginePublicKey()->getFingerprint()],
        ]);

        $table->render();
    }
}
