<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\SynchronizePayment\SynchronizePaymentCommand as SynchronizePaymentCommandBusCommand;
use League\Tactician\CommandBus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SynchronizePaymentCommands.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizePaymentCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    /**
     * SynchronizePaymentCommand constructor.
     *
     * @param CommandBus $commandBus
     */
    public function __construct(CommandBus $commandBus)
    {
        parent::__construct('talos:payment:sync');

        $this->commandBus = $commandBus;
    }

    protected function configure()
    {
        $this->addArgument('payment', InputArgument::REQUIRED, 'The db ID of the payment');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->commandBus->handle(new SynchronizePaymentCommandBusCommand($input->getArgument('payment')));
    }
}
