<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Cli;

use IssetBV\PaymentBundle\CommandBus\SynchronizeAutoTopupProfiles\SynchronizeAutoTopupProfilesCommand;
use IssetBV\PaymentBundle\CommandBus\SynchronizeIssuers\SynchronizeIssuersCommand;
use IssetBV\PaymentBundle\CommandBus\SynchronizeWalletTypes\SynchronizeWalletTypesCommand;
use IssetBV\TalosBundle\Entity\TalosPaymentMethod;
use League\Tactician\CommandBus;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SynchronizeTypesCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class SynchronizeCommand extends Command
{
    /**
     * @var CommandBus
     */
    private $commandBus;

    public function __construct(CommandBus $commandBus)
    {
        parent::__construct('talos:sync');

        $this->commandBus = $commandBus;
    }

    protected function configure()
    {
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // Load ideal issuers
        $this->commandBus->handle(new SynchronizeIssuersCommand(TalosPaymentMethod::SERVICE_NAME_IDEAL));

        $this->commandBus->handle(new SynchronizeWalletTypesCommand());

        $this->commandBus->handle(new SynchronizeAutoTopupProfilesCommand());
    }
}
