<?php

namespace IssetBV\PaymentBundle\Factory;
use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Mutation;
use IssetBV\PaymentBundle\Domain\Payment;
use IssetBV\PaymentBundle\Domain\PaymentIssuer;
use IssetBV\PaymentBundle\Domain\PaymentMethod;
use Money\Money;
use PhpOption\Option;

/**
 * Class DefaultPaymentFactory.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class DefaultPaymentFactory implements PaymentFactory
{

    /**
     * @param Invoice $invoice
     * @param Money $money
     * @param PaymentMethod $paymentMethod
     * @param PaymentIssuer $issuer
     * @param string $recurrentType
     *
     * @return Payment
     */
    public function createPayment(Invoice $invoice, Money $money, PaymentMethod $paymentMethod, PaymentIssuer $issuer = null, string $recurrentType): Payment
    {
        return new class() implements Payment
        {

            /**
             * @return Money
             */
            public function getAmount(): Money
            {
                // TODO: Implement getAmount() method.
            }

            /**
             * @return string
             */
            public function getIdentifier(): string
            {
                // TODO: Implement getIdentifier() method.
            }

            /**
             * @return Invoice
             */
            public function getInvoice(): Invoice
            {
                // TODO: Implement getInvoice() method.
            }

            /**
             * @return string
             */
            public function getReference(): string
            {
                // TODO: Implement getReference() method.
            }

            /**
             * @return PaymentMethod
             */
            public function getPaymentMethod(): PaymentMethod
            {
                // TODO: Implement getPaymentMethod() method.
            }

            /**
             * @return Option
             */
            public function getPaymentIssuer(): Option
            {
                // TODO: Implement getPaymentIssuer() method.
            }

            /**
             * @return string
             */
            public function getRecurrentType(): string
            {
                // TODO: Implement getRecurrentType() method.
            }

            /**
             * Returns true if this payment is usable for auto topup profiles.
             *
             * @return bool
             */
            public function isUsableForAutoTopup(): bool
            {
                // TODO: Implement isUsableForAutoTopup() method.
            }

            /**
             * This is a string now but we'll probably change some stuff here later.
             *
             * @return string
             */
            public function getStatus(): string
            {
                // TODO: Implement getStatus() method.
            }

            /**
             * @return Mutation[]
             */
            public function getMutations()
            {
                // TODO: Implement getMutations() method.
            }

            /**
             * @param string $accountName
             */
            public function setCustomerAccountName(string $accountName)
            {
                // TODO: Implement setCustomerAccountName() method.
            }

            /**
             * @param string $accountIdentifier
             */
            public function setCustomerAccountIdentifier(string $accountIdentifier)
            {
                // TODO: Implement setCustomerAccountIdentifier() method.
            }
        };
    }
}