<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Factory;

use IssetBV\PaymentBundle\Domain\Invoice\DefaultInvoiceNumber;
use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use IssetBV\PaymentBundle\Domain\Invoice\InvoiceNumber;
use Ramsey\Uuid\Uuid;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
class DefaultInvoiceFactory implements InvoiceFactory
{
    public function createInvoice(InvoiceNumber $invoiceNumber = null): Invoice
    {
        if ($invoiceNumber === null) {
            $invoiceNumber = new DefaultInvoiceNumber(Uuid::uuid4());
        }

        return new class($invoiceNumber) implements Invoice {
            /**
             * @var InvoiceNumber
             */
            private $invoiceNumber;

            public function __construct(InvoiceNumber $invoiceNumber)
            {
                $this->invoiceNumber = $invoiceNumber;
            }

            /**
             * @return InvoiceNumber
             */
            public function getNumber(): InvoiceNumber
            {
                return $this->invoiceNumber;
            }
        };
    }
}
