<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain\Repository;

use PhpOption\Option;

/**
 * Class PaymentRepository.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface PaymentRepository
{
    /**
     * @param string $paymentReference
     *
     * @return Option
     */
    public function findOneByReference(string $paymentReference): Option;

    /**
     * @param string $remoteIdentifier
     *
     * @return Option
     */
    public function findOneByRemoteIdentifier(string $remoteIdentifier): Option;
}
