<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use PhpOption\Option;

/**
 * Interface RemoteObject.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface RemoteObject
{
    /**
     * Returns the remote identifier of this object.
     *
     * @return Option
     */
    public function getRemoteIdentifier(): Option;

    /**
     * @param string $remoteIdentifier
     *
     * @deprecated This method is not strictly deprecated but I think it should not be part of this interface
     */
    public function setRemoteIdentifier(string $remoteIdentifier);

    /**
     * @param string $remoteStatusCode
     */
    public function setRemoteStatus(string $remoteStatusCode);

    /**
     * @return string
     */
    public function getRemoteStatus(): string;
}
