<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use IssetBV\PaymentBundle\Domain\Invoice\Invoice;
use Money\Money;
use PhpOption\Option;

/**
 * Interface Payment.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Payment
{
    /**
     * @return Money
     */
    public function getAmount(): Money;

    /**
     * @return string
     */
    public function getIdentifier(): string;

    /**
     * @return Invoice
     */
    public function getInvoice(): Invoice;

    /**
     * @return string
     */
    public function getReference(): string;

    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod(): PaymentMethod;

    /**
     * @return Option
     */
    public function getPaymentIssuer(): Option;

    /**
     * @return string
     */
    public function getRecurrentType(): string;

    /**
     * Returns true if this payment is usable for auto topup profiles.
     *
     * @return bool
     */
    public function isUsableForAutoTopup(): bool;

    /**
     * This is a string now but we'll probably change some stuff here later.
     *
     * @return string
     */
    public function getStatus(): string;

    /**
     * @return Mutation[]
     */
    public function getMutations();

    /**
     * @param string $accountName
     */
    public function setCustomerAccountName(string $accountName);

    /**
     * @param string $accountIdentifier
     */
    public function setCustomerAccountIdentifier(string $accountIdentifier);
}
