<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\Domain;

use PhpOption\Option;

/**
 * Interface Payment.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface ExecutablePayment extends Payment
{
    /**
     * @return PaymentMethod
     */
    public function getPaymentMethod(): PaymentMethod;

    /**
     * @return Option
     */
    public function getPaymentIssuer(): Option;

    /**
     * @return string
     */
    public function getReturnUrl(): string;

    /**
     * @return string
     */
    public function getPaymentUrl(): string;

    /**
     * @param string $paymentUrl
     */
    public function setPaymentUrl(string $paymentUrl);

    /**
     * @todo Does this belong here or can we remove this dependency?
     *
     * @return Wallet
     */
    public function getWallet(): Wallet;
}
