<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\SynchronizePayment;

use IssetBV\PaymentBundle\Domain\Payment;

/**
 * Class SynchronizePaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class SynchronizePaymentCommand
{
    /**
     * @var string
     */
    private $paymentIdentifier;

    /**
     * SynchronizePaymentCommand constructor.
     *
     * @param string $paymentIdentifier
     */
    public function __construct(string $paymentIdentifier)
    {
        $this->paymentIdentifier = $paymentIdentifier;
    }

    /**
     * @return string
     */
    public function getPaymentIdentifier(): string
    {
        return $this->paymentIdentifier;
    }

    /**
     * @param Payment $payment
     *
     * @return SynchronizePaymentCommand
     */
    public static function fromPayment(Payment $payment): SynchronizePaymentCommand
    {
        return new self($payment->getIdentifier());
    }
}
