<?php

declare(strict_types=1);

namespace IssetBV\PaymentBundle\CommandBus\ExecutePayment;

use IssetBV\TalosBundle\Gateway\Request\ClientData;
use PhpOption\Option;

/**
 * Class CreatePaymentCommand.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ExecutePaymentCommand
{
    /**
     * @var ClientData
     */
    private $clientData;

    /**
     * @var string
     */
    private $paymentIdentifier;

    /**
     * CreatePaymentCommand constructor.
     *
     * @param string $paymentIdentifier
     * @param ClientData $clientData
     */
    public function __construct(string $paymentIdentifier, ClientData $clientData = null)
    {
        $this->paymentIdentifier = $paymentIdentifier;
        $this->clientData = $clientData;
    }

    /**
     * @return string
     */
    public function getPaymentIdentifier(): string
    {
        return $this->paymentIdentifier;
    }

    /**
     * @return Option
     */
    public function getClientData(): Option
    {
        return Option::ensure($this->clientData);
    }
}
