<?php

declare(strict_types=1);

namespace IssetBV\TalosBundle\Gateway\Response;

use IssetBV\Json\Exception\InvalidPropertyAccessException;
use IssetBV\Json\JsonThing;
use IssetBV\TalosBundle\Gateway\Request\Request;
use PhpOption\None;
use PhpOption\Option;

/**
 * Class ResponseWrapper.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
final class ApiResponseWrapper
{
    /**
     * @var JsonThing
     */
    private $jsonData;

    /**
     * ResponseWrapper constructor.
     *
     * @param JsonThing $jsonThing
     */
    public function __construct(JsonThing $jsonThing)
    {
        $this->jsonData = $jsonThing;
    }

    /**
     * @return bool
     */
    public function isSuccessful(): bool
    {
        return true;
    }

    /**
     * @param Request $request
     *
     * @return Option
     */
    public function getResponseFor(Request $request): Option
    {
        /** @var JsonThing $response */
        foreach ($this->jsonData['Responses'] as $response) {
            if ($response['Nonce'] === $request->getNonce()) {
                try {
                    $wrappedResponse = WebResponse::fromJsonThing($response);
                } catch (InvalidPropertyAccessException $e) {
                    try {
                        $wrappedResponse = Response::fromJsonThing($response);
                    } catch (InvalidPropertyAccessException $b) {
                        throw $e;
                    }
                }

                return Option::ensure($wrappedResponse);
            }
        }

        return None::create();
    }
}
