<?php

namespace IssetBV\SettingsBundle\Compiler;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\Reference;

class SettingTagCompilerPass implements CompilerPassInterface
{

    public function process(ContainerBuilder $container)
    {
        if (!$container->hasDefinition('issetbv_settings.converter')) {
            return;
        }

        $definition = $container->getDefinition(
                'issetbv_settings.converter'
        );

        $taggedServices = $container->findTaggedServiceIds(
                'issetbv_settings.converter.helper'
        );
        foreach ($taggedServices as $id => $attributes) {
            $definition->addMethodCall(
                    'add', array(new Reference($id))
            );
        }
    }

}