<?php

namespace IssetBV\SettingsBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SettingGroup
 *
 * @ORM\Table(name="issetbv_setting_groups")
 * @ORM\Entity
 */
class SettingGroup
{

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="SettingGroup", inversedBy="groups")
     * @ORM\JoinColumn(name="setting_group_id", referencedColumnName="id", nullable=true)
     */
    private $group;

    /**
     * @ORM\OneToMany(targetEntity="SettingGroup", mappedBy="group")
     */
    private $groups;

    /**
     * @ORM\OneToMany(targetEntity="Setting", mappedBy="group")
     */
    private $settings;

    /**
     * @var string
     *
     * @ORM\Column(name="group_name", type="string", nullable=false)
     */
    private $name;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
        $this->settings = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return SettingGroup
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set group
     *
     * @param \IssetBV\SettingsBundle\Entity\SettingGroup $group
     * @return SettingGroup
     */
    public function setGroup(\IssetBV\SettingsBundle\Entity\SettingGroup $group = null)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return \IssetBV\SettingsBundle\Entity\SettingGroup 
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Add groups
     *
     * @param \IssetBV\SettingsBundle\Entity\SettingGroup $groups
     * @return SettingGroup
     */
    public function addGroup(\IssetBV\SettingsBundle\Entity\SettingGroup $groups)
    {
        $this->groups[] = $groups;

        return $this;
    }

    /**
     * Remove groups
     *
     * @param \IssetBV\SettingsBundle\Entity\SettingGroup $groups
     */
    public function removeGroup(\IssetBV\SettingsBundle\Entity\SettingGroup $groups)
    {
        $this->groups->removeElement($groups);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Add settings
     *
     * @param \IssetBV\SettingsBundle\Entity\Setting $settings
     * @return SettingGroup
     */
    public function addSetting(\IssetBV\SettingsBundle\Entity\Setting $settings)
    {
        $this->settings[] = $settings;

        return $this;
    }

    /**
     * Remove settings
     *
     * @param \IssetBV\SettingsBundle\Entity\Setting $settings
     */
    public function removeSetting(\IssetBV\SettingsBundle\Entity\Setting $settings)
    {
        $this->settings->removeElement($settings);
    }

    /**
     * Get settings
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSettings()
    {
        return $this->settings;
    }
}
