<?php

namespace IssetBV\SettingsBundle\Converter;

class Converter implements ConverterInterface
{

    private $helpers = array();

    public function add(ConverterHelper $helper)
    {
        $this->helpers[$helper->getKey()] = $helper;
    }

    /**
     *
     * @param String $type
     * @param String $value
     * @return mixed
     * @throws \IssetBV\SettingsBundle\Exception\ConverterMissingException
     */
    public function load($type, $value)
    {
        return $this->getHelper($type)->load($value);
    }

    /**
     *
     * @param String $type
     * @param String $value
     * @return mixed
     * @throws \IssetBV\SettingsBundle\Exception\ConverterMissingException
     */
    public function save($type, $value)
    {
        return $this->getHelper($type)->save($value);
    }

    /**
     * @param string $type
     * @return \IssetBV\SettingsBundle\Converter\ConverterHelper
     * @throws \IssetBV\SettingsBundle\Exception\ConverterMissingException
     */
    public function getHelper($type)
    {
        if (!array_key_exists($type, $this->helpers)) {
            throw new \IssetBV\SettingsBundle\Exception\ConverterMissingException('type: ' . $type, "doesn't exists. available: " . implode(', ', array_keys($this->helpers)));
        }
        return $this->helpers[$type];
    }

}