<?php

namespace IssetBV\SettingsBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\SettingsBundle\Exception\SettingMissingException;

class SettingRepository extends EntityRepository
{

    /**
     *
     * @param String $setting
     * @param array $group
     * @return \IssetBV\SettingsBundle\Entity\Setting
     * @throws SettingMissingException
     */
    public function getSetting($setting, array $group = null)
    {
        $query = $this->createQueryBuilder("s")
                ->select('s, t')
                ->join('s.type', 't')
                ->where('s.key = :setting')
                ->setParameter(':setting', $setting);

        $result = $query->getQuery()->getOneOrNullResult();
        /* @var $result \IssetBV\SettingsBundle\Entity\Setting */
        if (is_null($result)) {
            throw new SettingMissingException("Setting not found: " . $setting);
        }

        return $result;
    }

}