<?php

namespace IssetBV\SettingsBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

class LoadFixtures implements FixtureInterface, ContainerAwareInterface
{

    /**
     * @var ContainerInterface
     */
    private $container;
    private $types = array('class', 'int', 'datetime', 'bool', 'array', 'string');

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->types as $type) {
            $settingType = new \IssetBV\SettingsBundle\Entity\SettingType();
            $settingType->setType($type);
            $manager->persist($settingType);
        }

        //store on database
        $manager->flush();
    }

}