<?php

namespace IssetBv\TpcRestClientBundle\Services\Queue\Jobs;

use \IssetBv\TpcRestClientBundle\Services\Queue\Job;

class Flashnet extends Job
{

    public function __construct()
    {
        parent::__construct();
        $this->addData('flashnetOptimal', 1);
    }

    public function setCallType($callType)
    {
        $this->addData('callType', $callType);
    }

    public function setGuid($guid)
    {
        $this->addData('guid', $guid);
        return $this;
    }

    public function setLocation($location)
    {
        $this->addData('location', $location);
        return $this;
    }

    public function setFlashnetVersion($version)
    {
        $this->addData('flashnetVersion', $version);
        return $this;
    }

    public function setFlashnetName($name)
    {
        $this->addData('flashnetName', $name);
        return $this;
    }

    public function setFlashnetApp($app)
    {
        $this->addData('flashnetApp', $app);
        return $this;
    }

    public function setFlashnetIp($ip)
    {
        $this->addData('flashnetIp', $ip);
        return $this;
    }

    public function setFlashnetPort($port)
    {
        $this->addData('flashnetPort', $port);
        return $this;
    }

    public function setFlashnetVolumeName($volumeName)
    {
        $this->addData('flashnetVolumeName', $volumeName);
        return $this;
    }

    public function setFlashnetVolumeGroup($volumeGroup)
    {
        $this->addData('flashnetGroup', $volumeGroup);
        return $this;
    }

    public function setFlashnetArchiveNumber($archiveNumber)
    {
        $this->addData('flashnetArchiveNumber', $archiveNumber);
        return $this;
    }

    public function setFlashnetGroup($group)
    {
        $this->addData('flashnetGroup', $group);
        return $this;
    }

    public function setFlashnetPriority($prio)
    {
        $this->addData('flashnetPriority', $prio);
        return $this;
    }

}