<?php

namespace IssetBv\TpcRestClientBundle\Client;

class Payload
{

    private $command;
    private $method;
    private $data = array();
    private $headers = array();

    public function __construct($command, $method = 'get')
    {
        $this->command = $command;
        $this->method  = strtolower($method);
    }

    public function setCommand($command)
    {
        $this->command = $command;
        return $this;
    }

    public function getCommand()
    {
        return $this->command;
    }

    public function setMethod($method)
    {
        $this->method = strtolower($method);
        return $this;
    }

    public function setHeader($header, $value)
    {
        $this->headers[$header] = $value;
    }

    public function getHeaders()
    {
        return $this->headers;
    }

    public function getMethod()
    {
        return $this->method;
    }

    public function setData(array $data)
    {
        $this->data = $data;
        return $this;
    }

    public function addData($key, $value)
    {
        $this->data[$key] = $value;
        return $this;
    }

    public function getData()
    {
        return $this->data;
    }

}