<?php

namespace IssetBv\TpcRestClientBundle\Services\Queue\Jobs;

use \IssetBv\TpcRestClientBundle\Services\Queue\Job;

Class Transfer extends Job
{

    public function __construct()
    {
        parent::__construct('add', 'post');
    }

    public function setFileFrom($fileFrom)
    {
        $this->addData('fileFrom', $fileFrom);
        return $this;
    }

    public function setFileTo($fileTo)
    {
        $this->addData('fileTo', $fileTo);
        return $this;
    }

    public function setHost($host)
    {
        $this->addData('host', $host);
        return $this;
    }

    public function setAction($action)
    {
        $this->addData('action', $action);
        return $this;
    }

    public function setConnecterHost($connecterHost)
    {
        $this->addData('connecterHost', $connecterHost);
        return $this;
    }

    public function setConnecterPort($connecterPort)
    {
        $this->addData('connecterPort', $connecterPort);
        return $this;
    }

    public function setUsername($username)
    {
        $this->addData('username', $username);
        return $this;
    }

    public function setPassword($password)
    {
        $this->addData('password', $password);
        return $this;
    }

    public function setKeyLocation($keyLocation)
    {
        $this->addData('keyLocation', $keyLocation);
    }

}