<?php

namespace IssetBv\TpcRestClientBundle\Services\Logger;

use \IssetBv\TpcRestClientBundle\Client\ClientFactory;
use \IssetBv\TpcRestClientBundle\Client\Payload;

class Logger
{

    private $client;
    private $queueData;
    private $handle = false;

    public function __construct($url, $queueData = false)
    {
        $this->client    = ClientFactory::getClient($url);
        $this->queueData = $queueData;
    }

    private function getHandle()
    {
        if (!$this->handle) {
            $this->handle = fsockopen($this->queueData['ip'], $this->queueData['port']);
        }
        return $this->handle;
    }

    public function log($message, $level, $source, $parent = false)
    {
        if (!empty($this->queueData) && $this->queueData['use']) {
            $now  = new \DateTime();
            $data = array(
                'added' => $now->format("c"),
                'source' => $source,
                'message' => $message,
                'level' => $level
            );
            if ($parent) {
                $data['parent'] = $parent;
            }
            fwrite($this->getHandle(), json_encode($data) . "\n");
            return trim(fgets($this->getHandle()));
        } else {
            $payload = new Payload('add', 'post');

            $payload->addData('message', $message);
            $payload->addData('level', $level);
            $payload->addData('source', $source);
            if ($parent) {
                $payload->addData('parent', $parent);
            }

            try {
                return $this->client->sendPayload($payload);
            } catch (\Exception $e) {
                return false;
            }
        }
    }

    public function status($identifier)
    {
        $payload = new Payload($identifier, 'get');
        try {
            return $this->client->sendPayload($payload);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function base($identifier)
    {
        $payload = new Payload($identifier . '/base', 'get');
        try {
            return $this->client->sendPayload($payload);
        } catch (\Exception $e) {
            return false;
        }
    }

}
