<?php

namespace IssetBv\TpcRestClientBundle\Services\Drm;

use \IssetBv\TpcRestClientBundle\Services\Queue\Queue;

class DrmHandler extends Queue
{

    public function addWidevineJob($sourceUrl, $targetUrl, $callbackurl, $loggerIdentifier, $company, $type = false)
    {
        $srcUrl  = substr($sourceUrl, 0, strrpos($sourceUrl, '/') + 1);
        $srcFile = substr($sourceUrl, strrpos($sourceUrl, '/') + 1, strlen($sourceUrl));
        $tgtUrl  = substr($targetUrl, 0, strrpos($targetUrl, '/') + 1);
        $tgtFile = substr($targetUrl, strrpos($targetUrl, '/') + 1, strlen($targetUrl));

        $job = new \IssetBv\TpcRestClientBundle\Services\Queue\Jobs\Drm();
        $job->setName($this->createRandomGuid())
                ->setSourceUrl($srcUrl)
                ->setTargerUrl($tgtUrl)
                ->setSourceFiles($srcFile)
                ->setOutputFile($tgtFile)
                ->setDrmType('widevine')
                ->setCompany($company)
                ->setType($type ? $type : 'widevine')
                ->setCallback($callbackurl)
                ->setLoggerIdentifier($loggerIdentifier)
        ;

        return $this->addJob($job);
    }

    public function addBuyDrm10Job($sourceUrl, $targetUrl, $callbackurl, $loggerIdentifier, $company, $type = false)
    {

        $job = new \IssetBv\TpcRestClientBundle\Services\Queue\Jobs\Drm();
        $job->setName($this->createRandomGuid())
                ->setSourceUrl($sourceUrl)
                ->setTargerUrl($targetUrl)
                ->setDrmType('buydrm')
                ->setCompany($company)
                ->setType($type ? $type : 'buydrm')
                ->setCallback($callbackurl)
                ->setLoggerIdentifier($loggerIdentifier)
        ;

        return $this->addJob($job);
    }

    public function addMp4splitJob($sourceUrl, $targetUrl, $callback, $loggerIdentifier, $company, $drmType = 'mp4split', $licenseUrl = "", $licenseKey = "", $extra = '', $type = false)
    {

        $job = new \IssetBv\TpcRestClientBundle\Services\Queue\Jobs\Drm();
        $job
                ->setName($this->createRandomGuid())
                ->setSourceUrl($sourceUrl)
                ->setTargerUrl($targetUrl)
                ->setDrmType($drmType)
                ->setProvider((empty($licenseUrl) && empty($licenseKey)) ? 'none' : $licenseUrl . "=" . $licenseKey)
                ->setExtra($extra)
                ->setCompany($company)
                ->setType($type ? $type : $drmType)
                ->setCallback($callback)
                ->setLoggerIdentifier($loggerIdentifier)
        ;


        return $this->addJob($job);
    }

    public function addWmvPackagerJob($sourceUrl, $targetUrl, $callback, $loggerIdentifier, $company, $extra = '', $type = false)
    {
        $job = new \IssetBv\TpcRestClientBundle\Services\Queue\Jobs\Drm();
        $job
                ->setName($this->createRandomGuid())
                ->setSourceUrl($sourceUrl)
                ->setTargerUrl($targetUrl)
                ->setExtra($extra)
                ->setCompany($company)
                ->setDrmType('wmvpackager')
                ->setType($type ? $type : 'wmvpackager')
                ->setCallback($callback)
                ->setLoggerIdentifier($loggerIdentifier)
        ;

        return $this->addJob($job);
    }

    public function createRandomGuid()
    {
        return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
    }

}