<?php

namespace IssetBv\TpcRestClientBundle\Services\Queue;

use \IssetBv\TpcRestClientBundle\Client\Payload;

class JobDetail
{

    /**
     * @var \IssetBv\TpcRestClientBundle\Client\RestClient
     */
    private $client;
    private $identifier;

    public function __construct($client, $identifier)
    {
        $this->client     = $client;
        $this->identifier = $identifier;
    }

    /**
     * Delete a job
     * @param Integer  job id
     */
    public function delete()
    {
        return $this->client->sendPayload(new Payload($this->identifier . '/delete'));
    }

    /**
     * Pause job if it's queued or busy
     * @param Integer  job id
     */
    public function pause()
    {
        return $this->client->sendPayload(new Payload($this->identifier . '/pause'));
    }

    /**
     * Set paused jobs to queued
     * @param Integer  job id
     */
    public function unPause()
    {
        return $this->client->sendPayload(new Payload($this->identifier . '/continue'));
    }

    /**
     * Get the status of the job
     * @param Integer  job id
     */
    public function status()
    {
        return $this->client->sendPayload(new Payload($this->identifier . '/status'));
    }

}