<?php

namespace IssetBv\TpcRestClientBundle\Services\Ftp;

use \IssetBv\TpcRestClientBundle\Client\Payload;
use \IssetBv\TpcRestClientBundle\Services\Queue\Queue;

class FtpHandler extends Queue
{

    public function addFtpJob($ftpArray, $callbackurl, $loggerIdentifier, $type = false)
    {

        $payload = new Payload('add', 'post');
        $sources = array();
        $destinations = array();
        foreach ($ftpArray as $key => $value) {
            $sources[]      = $key;
            $destinations[] = $value;
        }
        $payload->addData('source', $sources);
        $payload->addData('destination', $destinations);
        $payload->addData('callbackurl', $callbackurl);
        $payload->addData('loggerIdentifier', $loggerIdentifier);
        if (!$type) {
            $payload->addData('type', $type);
        }
        return $this->client->sendPayload($payload);
    }

    public function deleteFtpFile($source, $callbackurl, $loggerIdentifier)
    {
        $payload = new Payload('add', 'post');
        $payload->addData('source', $source);
        $payload->addData('destination', 'deleteFile');
        $payload->addData('type', 'delete');
        $payload->addData('callbackurl', $callbackurl);
        $payload->addData('loggerIdentifier', $loggerIdentifier);

        return $this->client->sendPayload($payload);
    }

    public function createFtpDir($path)
    {
        $payload = new Payload('createdir');
        $payload->addData('path', $path);

        return $this->client->sendPayload($payload);
    }

    public function ftpFileExist($path)
    {
        $payload = new Payload('fileexist');
        $payload->addData('path', $path);

        return $this->client->sendPayload($payload);
    }

}