<?php

namespace IssetBv\TpcRestClientBundle\Services\Queue\Jobs;

use \IssetBv\TpcRestClientBundle\Services\Queue\Job;

Class Transcode extends Job
{

    public function __construct()
    {
        parent::__construct('add', 'post');

        $this->setTranscodeType(1);
    }

    public function setSource($source)
    {
        $this->addData('video_source', $source);
        return $this;
    }

    public function setAudioSource($audio_source)
    {
        $this->addData('audio_source', $audio_source);
        return $this;
    }

    public function setSubtitleSource($subtitle_source)
    {
        $this->addData('subtitle_source', $subtitle_source);
        return $this;
    }

    public function setDestination($destination)
    {
        $this->addData('destination', $destination);
        return $this;
    }

    public function setVideoPresetGuid($videopreset_guid)
    {
        $this->addData('video_preset_guid', $videopreset_guid);
        return $this;
    }

    public function setSubtitlePresetGuid($subtitlepreset_guid)
    {
        $this->addData('subtitle_preset_guid', $subtitlepreset_guid);
        return $this;
    }

    public function setTranscodeType($type_id)
    {
        $this->addData('transcoding_type', $type_id);
        return $this;
    }

    public function setOutputFilename($filename)
    {
        $this->addData('output_filename', $filename);
        return $this;
    }

    public function setMachinegroupGuid($machinegroup_guid)
    {
        $this->addData('machinegroup_guid', $machinegroup_guid);
        return $this;
    }

    public function getStatus()
    {
        $payload = new Payload('status', 'get');
        return $this->client->sendPayload($payload);
    }

    public function getQueue($min, $max)
    {
        $payload = new Payload('queue', 'get');
        $payload->addData('min', $min);
        $payload->addData('max', $max);
        return $this->client->sendPayload($payload);
    }

	public function setStart($seconds)
	{
		// Convert seconds to 1/27MHz units
		$this->addData('start', $seconds * 27000000);
		return $this;
	}

	public function setEnd($seconds)
	{
		// Convert seconds to 1/27MHz units
		$this->addData('end', $seconds * 27000000);
		return $this;
	}

	public function setFtpPath($ftp_path)
	{
        $this->addData('ftp_path', $ftp_path);
        return $this;
	}

	public function setSettings($settings)
	{
        $this->addData('settings', $settings);
        return $this;
	}

}