<?php

namespace IssetBv\TpcRestClientBundle\Services\Logger;

class Log
{

    private static $logger;
    private static $source;
    private static $stack = array();

    public static function init($logger, $source)
    {
        self::$logger = $logger;
        self::$source = $source;
    }

    public static function setBase($identifier)
    {
        self::$stack = array();
        if (!empty($identifier)) {
            array_push(self::$stack, $identifier);
        }
    }

    public static function error($message, $addToStack = true)
    {
        return self::log($message, 'error', $addToStack);
    }

    public static function info($message, $addToStack = true)
    {
        return self::log($message, 'info', $addToStack);
    }

    public static function debug($message, $addToStack = true)
    {
        return self::log($message, 'debug', $addToStack);
    }

    public static function log($message, $level = 'info', $addToStack = true)
    {
        $parent          = false;
        $stackIdentifier = end(self::$stack);
        if (!empty($stackIdentifier)) {
            $parent = $stackIdentifier;
        }

        $data       = self::$logger->log($message, $level, self::$source, $parent);
        $identifier = !empty($data->identifier) ? $data->identifier : $data;
        if ($identifier && $addToStack) {
            array_push(self::$stack, $identifier);
        }

        return $identifier;
    }

    public static function pop()
    {
        array_pop(self::$stack);
    }

}