<?php

namespace IssetBv\TpcRestClientBundle\Services\Drm;

use \IssetBv\TpcRestClientBundle\Client\Payload;
use \IssetBv\TpcRestClientBundle\Services\Queue\Queue;

class DrmHandler extends Queue
{

    public function addWidevineJob($sourceUrl, $targetUrl, $callbackurl, $loggerIdentifier)
    {
        $srcUrl  = substr($sourceUrl, 0, strrpos($sourceUrl, '/') + 1);
        $srcFile = substr($sourceUrl, strrpos($sourceUrl, '/') + 1, strlen($sourceUrl));
        $tgtUrl  = substr($targetUrl, 0, strrpos($targetUrl, '/') + 1);
        $tgtFile = substr($targetUrl, strrpos($targetUrl, '/') + 1, strlen($targetUrl));

        $name = $this->createRandomGuid();

        $payload = new Payload('add', 'post');
        $payload->addData('name', $name);
        $payload->addData('sourceUrl', $srcUrl);
        $payload->addData('targetUrl', $tgtUrl);
        $payload->addData('sourceFiles', $srcFile);
        $payload->addData('outputFile', $tgtFile);
        $payload->addData('type', 'widevine');
        $payload->addData('callbackurl', $callbackurl);
        $payload->addData('loggerIdentifier', $loggerIdentifier);

        return $this->client->sendPayload($payload);
    }

    public function addBuyDrm10Job($sourceUrl, $targetUrl, $callbackurl, $loggerIdentifier)
    {
        $name = $this->createRandomGuid();

        $payload = new Payload('add', 'post');
        $payload->addData('name', $name);
        $payload->addData('sourceUrl', $sourceUrl);
        $payload->addData('targetUrl', $targetUrl);
        $payload->addData('type', 'buydrm');
        $payload->addData('callbackurl', $callbackurl);
        $payload->addData('loggerIdentifier', $loggerIdentifier);

        return $this->client->sendPayload($payload);
    }

    public function addMp4splitJob($sourceUrl, $targetUrl, $callbackurl, $loggerIdentifier, $type = 'mp4split', $licenseUrl = "", $licenseKey = "", $extra = '')
    {

        $name = $this->createRandomGuid();

        $payload = new Payload('add', 'post');
        $payload->addData('name', $name);
        $payload->addData('sourceUrl', $sourceUrl);
        $payload->addData('targetUrl', $targetUrl);
        $payload->addData('type', $type);

        if (empty($licenseUrl) && empty($licenseKey)) {
            $payload->addData('provider', 'none');
        } else {
            $payload->addData('provider', $licenseUrl . "=" . $licenseKey);
        }

        $payload->addData('callbackurl', $callbackurl);
        $payload->addData('loggerIdentifier', $loggerIdentifier);
        $payload->addData('extra', $extra);

        return $this->client->sendPayload($payload);
    }

    public function createRandomGuid()
    {
        return sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
    }

}