<?php

namespace IssetBv\TpcRestClientBundle\Client;

use \Guzzle\Http\Client;

class RestClient
{

    /**
     *
     * @var \Guzzle\Http\Client
     */
    private $client;

    public function __construct($url)
    {
        $this->client = new Client($url);
    }

    public function sendPayload(Payload $payload)
    {
        if (!in_array($payload->getMethod(), array('get', 'post', 'put', 'delete'))) {
            throw new Exceptions\PayloadMethodNotAllowed('Method: ' . $payload->getMethod() . " isn't allowed");
        }

        if ($payload->getMethod() == 'get') {
            $request = $this->client->get($payload->getCommand());
            foreach ($payload->getData() as $key => $value) {
                $request->getQuery()->set($key, $value);
            }
        } else {
            $request = $this->client->{$payload->getMethod()}($payload->getCommand());
            $request->addPostFields($payload->getData());
        }

        foreach ($payload->getHeaders() as $header => $value) {
            if (!empty($value)) {
                $request->setHeader($header, $value);
            }
        }

        $response = $request->send();
        return json_decode($response->getBody());
    }

}