<?php

namespace IssetBv\TpcRestClientBundle\Services;

use IssetBv\TpcRestClientBundle\Services\Queue\Queue;
use IssetBv\TpcRestClientBundle\Services\Logger\Logger;
use IssetBv\TpcRestClientBundle\Services\File\FileHandler;
use IssetBv\TpcRestClientBundle\Services\Drm\DrmHandler;
use IssetBv\TpcRestClientBundle\Services\Ftp\FtpHandler;
use IssetBv\TpcRestClientBundle\Services\Baton\BatonHandler;

class ServiceFactory
{

    private $container;
    private $cache = array();

    public function __construct(\Symfony\Component\DependencyInjection\ContainerInterface $container)
    {
        $this->container = $container;
    }

    public function getFlashQueue($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_flashnet');
        }

        return new Queue($url);
    }

    public function getQueue($url)
    {
        return new Queue($url);
    }

    public function getLogger($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_logger');
        }

        return new Logger($url, $this->container->getParameter('logger_queue'));
    }

    /**
     *
     * @param String $url
     * @return \IssetBv\TpcRestClientBundle\Services\File\FileHandler
     */
    public function getFileHandler($url = false, $rebuild = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_filehandler');
        }
        if (!$rebuild && isset($this->cache['filehandler'][$url])) {
            return $this->cache['filehandler'][$url];
        }

        return $this->cache['filehandler'][$url] = new FileHandler($url);
    }

    public function getTranscodeQueue($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_transcoder');
        }

        return new Queue($url);
    }

    public function getDrmHandler($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_drmhandler');
        }
        return new DrmHandler($url);
    }

    public function getFtpHandler($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_ftphandler');
        }
        return new FtpHandler($url);
    }

    public function getBatonHandler($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_batonhandler');
        }
        return new BatonHandler($url);
    }

    public function getDivaHandler($url = false)
    {
        if (!$url) {
            $url = $this->getUrlByParameter('isset_bv_tpc_rest_client_diva');
        }

        return new Queue($url);
    }

    protected function getUrlByParameter($parameter)
    {
        $data = $this->container->getParameter($parameter);
        $url  = rtrim($data['url']['base'], '\/');
        if ($data['has_dev']) {
            $url = $this->setUrlByEnvironment($url);
        } else {
            $url .= '/';
        }

        if (!empty($data['url']['sub'])) {
            $url .= $data['url']['sub'];
        }
        return $url;
    }

    protected function setUrlByEnvironment($url)
    {
        $url = rtrim($url, '\/') . '/';
        $env = $this->container->getParameter('kernel.environment');
        if ($env != 'dev') {
            return $url;
        }

        return $url . 'app_dev.php/';
    }

}