<?php

namespace IssetBv\TpcRestClientBundle\Services\Queue;

use \IssetBv\TpcRestClientBundle\Client\ClientFactory;
use \IssetBv\TpcRestClientBundle\Client\Payload;

class Queue
{

    /**
     * @var \IssetBv\TpcRestClientBundle\Client\RestClient
     */
    protected $client;

    public function __construct($url)
    {
        $this->client = ClientFactory::getClient($url);
    }

    /**
     * Get all data from the queue
     * @param integer optional: offset
     * @param type optional: number of items
     * @param integer time in days
     */
    public function detail($min = 0, $max = 100, $time = 1, $status = "all states")
    {
        $payload = new Payload('queue');
        $payload->addData('min', $min);
        $payload->addData('max', $max);
        $payload->addData('time', $time);
        $payload->addData('status', $status);
        return $this->client->sendPayload($payload);
    }

    public function jobDetail($identifier)
    {
        $payload = new Payload($identifier . '/showjob');
        return $this->client->sendPayload($payload);
    }

    /*
     * Get the status of the queue
     */

    public function status()
    {
        return $this->client->sendPayload(new Payload('status'));
    }

    public function recentStatus($hours)
    {
        $payload = new Payload('status');
        $payload->addData('hours', $hours);
        return $this->client->sendPayload($payload);
    }

    /**
     * Pause all jobs in the queue that are queued or busy
     */
    public function pause()
    {
        return $this->client->sendPayload(new Payload('pause'));
    }

    /**
     * Continue all paused jobs in the queue
     */
    public function unPause()
    {
        return $this->client->sendPayload(new Payload('continue'));
    }

    public function getJob($identifier)
    {
        return new JobDetail($this->client, $identifier);
    }

    public function addJob(Job $job)
    {
        return $this->client->sendPayload($job);
    }

    public function redoJob($identifier)
    {
        $payload = new Payload($identifier . '/update', 'post');
        $payload->addData('message', '');
        $payload->addData('status', 'queued');
        return $this->client->sendPayload($payload);
    }

    public function removeJob($identifier)
    {
        $payload = new Payload($identifier . '/delete');
        return $this->client->sendPayload($payload);
    }

    public function retryCallback($days = -1)
    {
        $payload = new Payload('retrycallback');
        $payload->addData('days', $days);
        return $this->client->sendPayload($payload);
    }

    public function stopJob($identifier)
    {
        $payload = new Payload($identifier . '/update', 'post');
        $payload->addData('status', 'stopped');
        return $this->client->sendPayload($payload);
    }

    public function forceStartJob($identifier)
    {
        $payload = new Payload($identifier . '/forcestart', 'get');
        return $this->client->sendPayload($payload);
    }

    public function pauseJob($identifier)
    {
        $payload = new Payload($identifier . '/update', 'post');
        $payload->addData('status', 'paused');
        return $this->client->sendPayload($payload);
    }

    public function setPriorityJob($identifier, $priority)
    {
        $payload = new Payload($identifier . '/update', 'post');
        $payload->addData('priority', $priority);

        return $this->client->sendPayload($payload);
    }

}