<?php

namespace IssetBv\TpcRestClientBundle\Services\Logger;

use \IssetBv\TpcRestClientBundle\Client\ClientFactory;
use \IssetBv\TpcRestClientBundle\Client\Payload;

class Logger
{

    private $client;

    public function __construct($url)
    {
        $this->client = ClientFactory::getClient($url);
    }

    public function log($message, $level, $source, $parent = false)
    {
        $payload = new Payload('add', 'post');

        $payload->addData('message', $message);
        $payload->addData('level', $level);
        $payload->addData('source', $source);
        if ($parent) {
            $payload->addData('parent', $parent);
        }

        try {
            return $this->client->sendPayload($payload);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function status($identifier)
    {
        $payload = new Payload($identifier, 'get');
        try {
            return $this->client->sendPayload($payload);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function base($identifier)
    {
        $payload = new Payload($identifier . '/base', 'get');
        try {
            return $this->client->sendPayload($payload);
        } catch (\Exception $e) {
            return false;
        }
    }

}
