<?php

namespace IssetBV\RedisBundle\Redis;

class Client
{

    private $client;
    private $connected = false;

    /**
     * @var \Symfony\Bridge\Monolog\Logger
     */
    private $logger;
    private $useDummy = false;
    private $prefix   = '';

    public function __construct($connection, $logger, $useDummy = false, $prefix = '')
    {
        $this->logger = $logger;
        if (is_array($connection) && count($connection) == 1) {
            $connection = array_pop($connection);
        }

        $this->client   = new \Predis\Client($connection);
        $this->useDummy = $useDummy;
        $this->prefix   = $prefix;
    }

    public function getClient()
    {
        if (!$this->connected) {

            if ($this->useDummy === true) {
                $this->client    = new Dummy();
                $this->connected = true;
            } else {
                try {
                    $this->client->connect();
                    $this->connected = true;
                } catch (\Exception $e) {
                    $this->logger->error("REDIS: " . $e->getMessage());
                    $this->client    = new Dummy();
                    $this->connected = true;
                }
            }
        }
        return $this->client;
    }

    public function getQueue($name)
    {
        return new Type\Queue($this->getClient(), $name);
    }

    public function __destruct()
    {
        $this->client->disconnect();
    }

    public function getKey($type, $identifier)
    {
        return $this->prefix . '_' . $type . '_' . $identifier;
    }

}
