<?php

namespace IssetBV\RedisBundle\Redis;

class Client
{

    private $client;
    private $connected = false;

    /**
     * @var \Symfony\Bridge\Monolog\Logger
     */
    private $logger;

    public function __construct($connection, $logger)
    {
        $this->logger = $logger;
        if (is_array($connection) && count($connection) == 1) {
            $connection = array_pop($connection);
        }

        $this->client = new \Predis\Client($connection);
    }

    public function getClient()
    {
        if (!$this->connected) {
            try {
                $this->client->connect();
                $this->connected = true;
            } catch (\Exception $e) {
                $this->logger->error("REDIS: " . $e->getMessage());
                $this->client    = new Dummy();
                $this->connected = true;
            }
        }
        return $this->client;
    }

    public function getQueue($name)
    {
        return new Type\Queue($this->getClient(), $name);
    }

    public function __destruct()
    {
        $this->client->disconnect();
    }

}
