<?php

namespace IssetBV\RedisBundle\Redis;

class Client
{

    private $client;

    public function __construct($connection)
    {
        if(is_array($connection) && count($connection) == 1){
            $connection = array_pop($connection);
        }

        $this->client = new \Predis\Client($connection);
    }

    public function getClient()
    {
        return $this->client;
    }

    public function getQueue($name)
    {
        return new Type\Queue($this->getClient(), $name);
    }

    public function __destruct()
    {
        $this->client->disconnect();
    }

}
