<?php

namespace IssetBV\RedisBundle\Redis\Type;

class Queue
{

    private $client;
    private $name;

    public function __construct($client, $name)
    {
        $this->client = $client;
        $this->name   = $name;
    }

    public function add($value)
    {
        $this->client->LPUSH($this->name, $value);
    }

    public function peek()
    {
        $return = $this->client->LRANGE($this->name, -1, -1);
        if (empty($return)) {
            return false;
        }

        return $return[0];
    }

    public function pop()
    {
        return $this->client->RPOP($this->name);
    }

}
