<?php

declare(strict_types=1);

namespace IssetBV\Queuing\Queue;

interface QueueInterface
{
    /**
     * @param QueueMessageInterface $connectionMessage
     */
    public function ack(QueueMessageInterface $connectionMessage);

    /**
     * @param QueueMessageInterface $connectionMessage
     * @param bool $requeue
     */
    public function reject(QueueMessageInterface $connectionMessage, bool $requeue = false);

    /**
     * @param string $message
     * @param array $headers
     */
    public function send(string $message, array $headers = []);

    /**
     * @param int $wait
     *
     * @return QueueMessageInterface|null
     */
    public function receive(int $wait = 0);

    public function getConnection(): ConnectionInterface;
}
