<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Service\Log;

use Psr\Log\NullLogger;

class NullLoggerSingleton
{
    /**
     * @var NullLogger
     */
    private static $instance;

    /**
     * @return NullLogger
     */
    public static function getSingleton(): NullLogger
    {
        if (null === self::$instance) {
            self::$instance = new NullLogger();
        }

        return self::$instance;
    }
}
