<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle;

use IssetBV\Queuing\Message\Consumer\ConsumerInterface;
use IssetBV\Queuing\MessageBundle\Compiler\MessageBundleCompilerPass;
use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use Symfony\Component\HttpKernel\Kernel;

class IssetBVQueuingMessageBundle extends Bundle
{
    /**
     * @param ContainerBuilder $container
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);
        $container->addCompilerPass(new MessageBundleCompilerPass());

        if (Kernel::MAJOR_VERSION > 3 || (Kernel::MAJOR_VERSION === 3 && Kernel::MINOR_VERSION >= 3)) {
            $container
                ->registerForAutoconfiguration(ConsumerInterface::class)
                ->addTag(IssetBVQueuingMessageExtension::PREFIX . 'consumer');
        }
    }
}
