<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_queuing_message');
        $rootNode->children()->scalarNode('default_queue')->defaultNull()->end();
        $rootNode->children()->scalarNode('default_encoder')->defaultNull()->end();
        $rootNode->children()->scalarNode('default_decoder')->defaultNull()->end();
        if ($rootNode instanceof ArrayNodeDefinition) {
            $this->addQueues($rootNode);
        }

        return $treeBuilder;
    }

    private function addQueues(ArrayNodeDefinition $rootNode)
    {
        $rootNode
            ->children()
            ->arrayNode('queues')
            ->prototype('array')
            ->children()
            ->scalarNode('connection')->isRequired()->end()
            ->scalarNode('exchange')->isRequired()->end()
            ->scalarNode('queue')->defaultNull()->end()
            ->scalarNode('consumer_container_clear_doctrine')->defaultTrue()->end()
            ->scalarNode('decoder_container')->defaultNull()->end()
            ->scalarNode('consumer_container')->defaultNull()->end()
            ->arrayNode('consumer_container_pre_consumes')->scalarPrototype()->end()->end()
            ->arrayNode('consumer_container_post_consumes')->scalarPrototype()->end()->end()
            ->scalarNode('exception_handler')->defaultNull()->end()
            ->arrayNode('options')
            ->useAttributeAsKey('name')->prototype('scalar')->end()
            ->end()
            ->end()
            ->end()
            ->end()
            ->end();
    }
}
