<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Service\Log;

use Psr\Log\LoggerInterface;
use Psr\Log\LoggerTrait as PsrTrait;

/**
 * Class LoggerTrait.
 */
trait LoggerTrait
{
    use PsrTrait;
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Sets a logger instance on the object.
     *
     * @param LoggerInterface $logger
     */
    public function setLogger(LoggerInterface $logger)
    {
        $this->logger = $logger;
    }

    public function log($level, $message, array $context = [])
    {
        $this->getLogger()->log($level, $message, $context);
    }

    /**
     * @return LoggerInterface
     */
    private function getLogger(): LoggerInterface
    {
        if (null === $this->logger) {
            $this->logger = NullLoggerSingleton::getSingleton();
        }

        return $this->logger;
    }
}
