<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Command;

use IssetBV\Queuing\MessageBundle\DependencyInjection\IssetBVQueuingMessageExtension;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class QueuingQueueWarmupCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:queuing:queue:warmup')
            ->addArgument('queue', InputArgument::REQUIRED)
            ->setDescription('de queues a message for the given queue')
            ->addOption('type', 'ti', InputOption::VALUE_OPTIONAL, 'timeout time in ms');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $queue = IssetBVQueuingMessageExtension::PREFIX . 'queue.' . $input->getArgument('queue');
        if (!$this->getContainer()->has($queue)) {
            $output->writeln('<error>Not found queue: ' . $input->getArgument('queue') . '</error>');
            return;
        }
        $options = [
            'type' => $input->getOption('type')
        ];
        $this->getContainer()->get($queue)->warmUp($options);
    }
}