<?php

declare(strict_types=1);

namespace IssetBV\Queuing\MessageBundle\Service\DeQueuer;

use IssetBV\Queuing\Message\DeQueuer\DeQueuerExceptionHandlerDataInterface;
use IssetBV\Queuing\Message\DeQueuer\DeQueuerExceptionHandlerInterface;
use IssetBV\Queuing\MessageBundle\Service\Log\Loggable;
use IssetBV\Queuing\MessageBundle\Service\Log\LoggerTrait;

class DeQueuerExceptionHandlerReject implements DeQueuerExceptionHandlerInterface, Loggable
{
    use LoggerTrait;

    public function handle(DeQueuerExceptionHandlerDataInterface $data)
    {
        $data->getQueue()->reject($data->getMessage());
        $connection = $data->getQueue()->getConnection()->getName();
        $this->error('Message rejected exception occurred on connection ' . $connection . ': ' . $data->getException()->getMessage());
    }
}
